<?php
session_start();
$title = 'Create Account';
$slug = 'register';
include '.header.php';
?>

  <main class="main">

    <!-- Page Title -->
    <div class="page-title dark-background" data-aos="fade" style="background-image: url(assets/img/background.inner.2.jpg);">
      <div class="container position-relative">
        <h1><?=$title?></h1>
        <p>Esse dolorum voluptatum ullam est sint nemo et est ipsa porro placeat quibusdam quia assumenda numquam molestias.</p>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="index.php">Home</a></li>
            <li class="current">register</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->
<?php
if(isset($_SESSION['message'])) {

  if($_SESSION['message'] == 'alreadyregistered') {
  echo '<div class="alert alert-warning text-center">
  <strong>Warning!</strong> That email is already registered.
  </div>';
  }
  if($_SESSION['message'] == 'accountcreated') {
  echo '<div class="alert alert-success text-center">
  <strong>Success!</strong> Account created successfully! A welcome email has been sent. Check your email. Remember to check your spam folder too.
  </div>'; 
  }

unset($_SESSION['message']);
}
?>
    <!-- About 3 Section -->
    <section id="about-3" class="about-3 section">

      <div class="container">
        <div class="row gy-4 justify-content-between align-items-center">
          <div class="col-lg-6 order-lg-2 position-relative" data-aos="zoom-out">
                <div class="card mx-auto" style="max-width: 100%; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);">
        <div class="card-body">
            <h2 class="text-center">Create an Account</h2>
          
            <!-- Registration Form -->
            <form action="members/register_process.php" method="POST">
                <div class="row">
                    <!-- First Name -->
                    <div class="col-md-6 mb-3">
                        <label for="firstName" class="form-label">First Name</label>
                        <input type="text" class="form-control" id="firstName" name="firstName" <?php if(isset($_SESSION['firstName'])) { echo 'value="'.$_SESSION['firstName'].'"'; } ?> required>
                    </div>

                    <!-- Last Name -->
                    <div class="col-md-6 mb-3">
                        <label for="lastName" class="form-label">Last Name</label>
                        <input type="text" class="form-control" id="lastName" name="lastName" <?php if(isset($_SESSION['lastName'])) { echo 'value="'.$_SESSION['lastName'].'"'; } ?> required>
                    </div>
                </div>

                <div class="row">
                    <!-- Phone Number -->
                    <div class="col-md-6 mb-3">
                        <label for="phone" class="form-label">Phone Number</label>
                        <input type="tel" class="form-control" id="phone" name="phone" <?php if(isset($_SESSION['phone'])) { echo 'value="'.$_SESSION['phone'].'"'; } ?> required>
                    </div>

                    <!-- Email -->
                    <div class="col-md-6 mb-3">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" class="form-control" id="email" name="email" <?php if(isset($_SESSION['email'])) { echo 'value="'.$_SESSION['email'].'"'; } ?> required>
                    </div>
                </div>
<style>
    .input-group-text {
        background-color: transparent;
        border: none;
    }
</style>

                <div class="row">
    <!-- Password -->
    <div class="col-md-6 mb-3">
        <label for="password" class="form-label">Password</label>
        <div class="input-group">
            <input type="password" class="form-control" id="password" name="password" required>
            <span class="input-group-text">
                <i class="toggle-password bi bi-eye" id="togglePassword" style="cursor: pointer;"></i>
            </span>
        </div>
    </div>

    <!-- Confirm Password -->
    <div class="col-md-6 mb-3">
        <label for="confirmPassword" class="form-label">Confirm Password</label>
        <div class="input-group">
            <input type="password" class="form-control" id="confirmPassword" name="confirmPassword" required>
            <span class="input-group-text">
                <i class="toggle-password bi bi-eye" id="toggleConfirmPassword" style="cursor: pointer;"></i>
            </span>
        </div>
    </div>
</div>



                <div class="row">
                    <!-- Company Name -->
                    <div class="col-md-6 mb-3">
                        <label for="companyName" class="form-label">Company Name</label>
                        <input type="text" class="form-control" id="companyName" name="companyName" <?php if(isset($_SESSION['companyName'])) { echo 'value="'.$_SESSION['companyName'].'"'; } ?> required>
                    </div>
<div class="row">
    <!-- Street Address -->
    <div class="col-md-12 mb-3">
        <label for="address" class="form-label">Street Address</label>
        <input type="text" class="form-control" id="address" name="address" <?php if(isset($_SESSION['address'])) { echo 'value="'.$_SESSION['address'].'"'; } ?> required>
    </div>
</div>

<div class="row">
    <!-- City -->
    <div class="col-md-6 mb-3">
        <label for="city" class="form-label">City</label>
        <input type="text" class="form-control" id="city" name="city" <?php if(isset($_SESSION['city'])) { echo 'value="'.$_SESSION['city'].'"'; } ?> required>
    </div>

    <!-- State -->
    <div class="col-md-6 mb-3">
        <label for="state" class="form-label">State</label>
        <input type="text" class="form-control" id="state" name="state" <?php if(isset($_SESSION['state'])) { echo 'value="'.$_SESSION['state'].'"'; } ?> required>
    </div>
</div>

<div class="row">
    <!-- ZIP Code -->
    <div class="col-md-6 mb-3">
        <label for="zip" class="form-label">ZIP/Postal Code</label>
        <input type="text" class="form-control" id="zip" name="zip" <?php if(isset($_SESSION['zip'])) { echo 'value="'.$_SESSION['zip'].'"'; } ?> required>
    </div>

    <!-- Country -->
    <div class="col-md-6 mb-3">
        <label for="country" class="form-label">Country</label>
        <select class="form-control" id="country" name="country" required>
            <option value="">Select Country</option>
            <option value="USA" <?php if(isset($_SESSION['country']) && $_SESSION['country'] == 'USA') echo 'selected'; ?>>United States</option>
            <option value="Canada" <?php if(isset($_SESSION['country']) && $_SESSION['country'] == 'Canada') echo 'selected'; ?>>Canada</option>
            <option value="UK" <?php if(isset($_SESSION['country']) && $_SESSION['country'] == 'UK') echo 'selected'; ?>>United Kingdom</option>
            <option value="Australia" <?php if(isset($_SESSION['country']) && $_SESSION['country'] == 'Australia') echo 'selected'; ?>>Australia</option>
            <option value="Other" <?php if(isset($_SESSION['country']) && $_SESSION['country'] == 'Other') echo 'selected'; ?>>Other</option>
        </select>
    </div>
</div>

                    <!-- Agree to Terms Checkbox -->
                    <div class="col-md-6 mb-3 d-flex align-items-center">
                        <div class="form-check w-100">
                            <input type="checkbox" class="form-check-input" id="agree" name="agree" required>
                            <label class="form-check-label ms-2" for="agree">
                                I agree to the <a href="terms.html" target="_blank">Terms and Conditions</a>
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <button type="submit" class="btn-cta w-100">Create Account</button>
            </form>
        </div>
    </div>
          </div>
          <div class="col-lg-5 order-lg-1" data-aos="fade-up" data-aos-delay="100">
            <h2 class="content-title mb-4">Lorem ipsum dolor sit.</h2>
            <p class="mb-4">
              Lorem ipsum dolor sit amet consectetur adipisicing elit. Enim
              necessitatibus placeat, atque qui voluptatem velit explicabo vitae
              repellendus architecto provident nisi ullam minus asperiores commodi!
              Tenetur, repellat aliquam nihil illo.
            </p>
            <ul class="list-unstyled list-check">
              <li>Lorem ipsum dolor sit amet</li>
              <li>Velit explicabo vitae repellendu</li>
              <li>Repellat aliquam nihil illo</li>
            </ul>

            <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Repellendus, velit?</p>
          </div>
        </div>
      </div>
    </section><!-- /About 3 Section -->




    <!-- Call To Action Section -->
    <section id="call-to-action" class="call-to-action section light-background">

      <div class="content">
        <div class="container">
          <div class="row align-items-center">
            <div class="col-lg-6">
              <h3>Subscribe To Our Newsletter</h3>
              <p class="opacity-50">
                Lorem ipsum dolor sit amet consectetur adipisicing elit.
                Nesciunt, reprehenderit!
              </p>
            </div>
            <div class="col-lg-6">
              <form action="forms/newsletter.php" class="form-subscribe php-email-form">
                <div class="form-group d-flex align-items-stretch">
                  <input type="email" name="email" class="form-control h-100" placeholder="Enter your e-mail">
                  <input type="submit" class="btn btn-secondary px-4" value="Subcribe">
                </div>
                <div class="loading">Loading</div>
                <div class="error-message"></div>
                <div class="sent-message">
                  Your subscription request has been sent. Thank you!
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section><!-- /Call To Action Section -->

  </main>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const togglePassword = document.getElementById('togglePassword');
    const toggleConfirmPassword = document.getElementById('toggleConfirmPassword');
    const passwordField = document.getElementById('password');
    const confirmPasswordField = document.getElementById('confirmPassword');

    togglePassword.addEventListener('click', function() {
        const type = passwordField.type === 'password' ? 'text' : 'password';
        passwordField.type = type;
        // Toggle icon class between eye and eye-slash
        this.classList.toggle('bi-eye');
        this.classList.toggle('bi-eye-slash');
    });

    toggleConfirmPassword.addEventListener('click', function() {
        const type = confirmPasswordField.type === 'password' ? 'text' : 'password';
        confirmPasswordField.type = type;
        // Toggle icon class between eye and eye-slash
        this.classList.toggle('bi-eye');
        this.classList.toggle('bi-eye-slash');
    });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.querySelector('form').addEventListener('submit', function(e) {
        const password = document.getElementById('password').value;
        const confirmPassword = document.getElementById('confirmPassword').value;

        // Updated Regular expression for the password
        const passwordRegex = /^(?=.*[A-Z])(?=.*\d)(?=.*[\W_])[A-Za-z\d\W_]{8,}$/;

        if (!passwordRegex.test(password)) {
            alert('Password must be at least 8 characters long and include at least one uppercase letter, one number, and one special character.');
            e.preventDefault(); // Prevent form submission
        } else if (password !== confirmPassword) {
            alert('Passwords do not match.');
            e.preventDefault(); // Prevent form submission
        }
    });
});
</script>


<?php include '.footer.php'; ?>